/*
 Wigan Wallgate: An open-source implementation of Grand Central Dispatch
 
 Copyright (c) 2009 Matt Wright
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 */

#include <stdlib.h>
#if __MAC_OS_X_VERSION_MIN_REQUIRED >= 1060
#include_next <dispatch/object.h>
#else

#ifndef __DISPATCH_OBJECT_H__
#define __DISPATCH_OBJECT_H__

#include <dispatch/base.h>

typedef void (*dispatch_function_t)(void*);

#if !defined(__cplusplus)
struct dispatch_object_s
{
  int retain_count;
  int suspend_count;
  
  void (^dealloc)(void);
  void (^suspend)(void);
  void (^resume)(void);
  
  dispatch_function_t finaliser;
  void *context;
};
#endif

#if defined(__cplusplus)
extern "C" {
#endif

void dispatch_retain(dispatch_object_t object);
void dispatch_release(dispatch_object_t object);
void dispatch_suspend(dispatch_object_t object);
void dispatch_resume(dispatch_object_t object);

void dispatch_set_finalizer_f(dispatch_object_t object, dispatch_function_t finaliser);

void *dispatch_get_context(dispatch_object_t object);
void dispatch_set_context(dispatch_object_t object, void *context);

#if defined(__cplusplus)
}
#endif

#endif // __DISPATCH_OBJECT_H__

#endif
